/*(@!*************************************************************************
SOCIETE : ENAG    Code affaire :    	   Ref logiciel : 
******************************************************************************
Fichier						: LCD.c
Language de programmation	: Microchip C18
Environnement logiciel		: MPLAB 7.60
Environnement materiel		: Carte d'evaluation PICDEM 2 PLUS
Microcontrolleur			: Microchip PIC 18F4682
Fichier projet				: 
Option de compilation		: Defaut 
Option d'edition de liens	: Defaut
------------------------------------------------------------------------------
Description gnrale : 
					**Maquette salon**
 
------------------------------------------------------------------------------
Liste des fonctionnalits :

******************************************************************************
Version !    Date    !    Auteur    !   Ref   !  Commentaires
------------------------------------------------------------------------------
 1.0    ! 15/11/2007 !  GEORGIN.N   ! Version Initiale  
        !            !              !         ! 
*************************************************************************@!)*/


 #include <p18cxxx.h>
 #include <delays.h>
 #include "xlcd.h"


 #define A4 PORTAbits.RA4
 #define A5 PORTAbits.RA5
 #define RETRO PORTCbits.RC0
 
#pragma config OSC = HS		//Config du type de l'oscillateur

int i,result;

void main (void);
void init_uc(void);
void delay(void);
void DelayMs(unsigned char cpt);

void DelayFor18TCY(void);
void DelayPORXLCD(void);
void DelayXLCD(void);


void main (void)
{
init_uc();


while(1)
 {
OpenXLCD( FOUR_BIT & LINES_5X7 );
DelayXLCD();
WriteCmdXLCD(DON & CURSOR_ON & BLINK_ON );
DelayXLCD();
WriteCmdXLCD(0x83);
while(BusyXLCD());
//WriteDataXLCD("VOLTMETER");
putrsXLCD("VOLTMETER");

 }
}


/***************************************************************************
Nom   : void init_uc(void)
Role  :Initialisation du PIC
*****************************************************************************/
void init_uc(void)
{
 TRISA=0x23;					// PORTA en sortie sauf RA5 et RA0 et RA1
 TRISB=0x00;					// PORTB en sortie
 TRISC=0x00;					// PORTC en sortie
 TRISD=0x00;					// PORTD en sortie
 ADCON1=0b00001110;				//Configuration du portA en numrique sauf A0 en analogique
 PORTB=0x00;
 PORTC=0x00;
 PORTD=0x00;

}

/***************************************************************************
Nom   : void delay(void)
Role  : temporisation
*****************************************************************************/
void delay(void)
{
int i;

for(i=0; i<20000; i++);
 
}


/****************************************************************
Nom   :	void DelayMs(uchar cpt)
Role  :	Temporisation en millisecondes
****************************************************************/
void DelayMs(unsigned char cpt)
{
	unsigned short t ;
	while (cpt != 0)
	{
		//CLRWDT() ;
		-- cpt ;
		t = 450 ;
		while (t !=0)	-- t ;
	}
}

/***********LCD SUPPORT FUNCTIONS*******************************/
/****************************************************************
Nom   :	void DelayXLCD(void)
Role  :	Temporisation 5 ms
****************************************************************/
void DelayXLCD(void)
{
Delay100TCYx(0x36);		//100TCY*54
return;
}

/****************************************************************
Nom   :	void DelayPORXLCD(void)
Role  :	Temporisation 15 ms
****************************************************************/
void DelayPORXLCD(void)
{
Delay100TCYx(0xA0);		//100TCY*160
return;
}

/****************************************************************
Nom   :	void DelayFor18TCy(void)
Role  :	Temporisation 5 ms
****************************************************************/
void DelayFor18TCY(void)
{
Delay100TCYx(0x2);		//Delay 20 cycles
return;
}


